﻿//////////////////////////////////////////////
// InputProcessor.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkMaths
{
	class Point ;
}

namespace nkWinUi
{
	class Component ;
	class InputDescriptor ;
}

/// Class ------------------------------------

namespace nkWinUi
{
	class InputProcessor
	{
		public :

			// Constructor, destructor
			InputProcessor () noexcept ;
			virtual ~InputProcessor () ;

			// Tracking
			virtual bool requestMouseTracking (Component* caller, bool value) = 0 ;

			// Events
			virtual void simulateEvent (Component* component, const InputDescriptor& inputDescription) = 0 ;
	} ;
}